<?php
App::uses('AppController', 'Controller');

class OptionsController extends AppController
{
    public $layout = 'admin';

    public function beforeFilter()
    {
        parent::beforeFilter();

        if (in_array($this->request->action, array('admin_index'))) {
            if ($this->request->is(array('post', 'put'))) {
                if ($this->Auth->user('account_type') == 'Demo') {
                    $this->Flash->set(__('This request is disabled into demo.'), array(
                        'element' => 'error'
                    ));
                    return $this->redirect($this->referer());
                }
            }
        }
    }

    public function isAuthorized($user = null)
    {
        return parent::isAuthorized($user);
    }

    public function admin_index()
    {
        $this->loadModel('Plan');
        $plans = $this->Plan->find('list', array(
            'fields' => array('Plan.id', 'Plan.title'),
            'conditions' => array(
                'Plan.enable' => 1
            ),
            'order' => 'Plan.title ASC'
        ));
        $this->set('plans', $plans);


        $options = $this->Option->find('all');
        $settings = array();
        foreach ($options as $key => $option) {
            $settings[$option['Option']['option_name']] = array(
                'id' => $option['Option']['id'],
                'option_value' => $option['Option']['option_value']
            );
        }
        $this->set('options', $options);
        $this->set('settings', $settings);

        if ($this->request->is(array('post', 'put'))) {
            if ($this->Option->saveAll($this->request->data['Option'])) {
                $this->Flash->set('Settings have been updated.', array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'index'));
            } else {
                //debug($this->Option->validationErrors);
                $this->Flash->set('Unable to update settings.', array(
                    'element' => 'error'
                ));
            }
        }

        if (!$this->request->data) {
            $this->request->data = $settings;
        }
    }
}
